"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BLOCK_NUMBER_CONFIGS = exports.DEFAULT_BLOCK_NUMBER_CONFIGS = exports.constructSameBlockNumberConfigsMap = exports.NETWORKS_WITH_SAME_BLOCK_NUMBER_CONFIGS = exports.SUCCESS_RATE_FAILURE_OVERRIDES = exports.DEFAULT_SUCCESS_RATE_FAILURE_OVERRIDES = exports.constructSameSuccessRateFailureOverridesMap = exports.NETWORKS_WITH_SAME_SUCCESS_RATE_FAILURE_OVERRIDES = exports.GAS_ERROR_FAILURE_OVERRIDES = exports.DEFAULT_GAS_ERROR_FAILURE_OVERRIDES = exports.constructSameGasErrorFailureOverridesMap = exports.NETWORKS_WITH_SAME_GAS_ERROR_FAILURE_OVERRIDES = exports.BATCH_PARAMS = exports.DEFAULT_BATCH_PARAMS = exports.constructSameBatchParamsMap = exports.NETWORKS_WITH_SAME_BATCH_PARAMS = exports.RETRY_OPTIONS = exports.DEFAULT_RETRY_OPTIONS = exports.constructSameRetryOptionsMap = exports.NETWORKS_WITH_SAME_RETRY_OPTIONS = void 0;
const sdk_core_1 = require("@uniswap/sdk-core");
exports.NETWORKS_WITH_SAME_RETRY_OPTIONS = Object.values(sdk_core_1.ChainId);
function constructSameRetryOptionsMap(retryOptions, additionalNetworks = []) {
    return exports.NETWORKS_WITH_SAME_RETRY_OPTIONS.concat(additionalNetworks).reduce((memo, chainId) => {
        memo[chainId] = retryOptions;
        return memo;
    }, {});
}
exports.constructSameRetryOptionsMap = constructSameRetryOptionsMap;
exports.DEFAULT_RETRY_OPTIONS = {
    retries: 2,
    minTimeout: 100,
    maxTimeout: 1000,
};
exports.RETRY_OPTIONS = Object.assign({}, constructSameRetryOptionsMap(exports.DEFAULT_RETRY_OPTIONS));
exports.NETWORKS_WITH_SAME_BATCH_PARAMS = Object.values(sdk_core_1.ChainId);
function constructSameBatchParamsMap(batchParams, additionalNetworks = []) {
    return exports.NETWORKS_WITH_SAME_BATCH_PARAMS.concat(additionalNetworks).reduce((memo, chainId) => {
        memo[chainId] = batchParams;
        return memo;
    }, {});
}
exports.constructSameBatchParamsMap = constructSameBatchParamsMap;
exports.DEFAULT_BATCH_PARAMS = {
    multicallChunk: 210,
    gasLimitPerCall: 705000,
    quoteMinSuccessRate: 0.15,
};
exports.BATCH_PARAMS = Object.assign({}, constructSameBatchParamsMap(exports.DEFAULT_BATCH_PARAMS));
exports.NETWORKS_WITH_SAME_GAS_ERROR_FAILURE_OVERRIDES = Object.values(sdk_core_1.ChainId);
function constructSameGasErrorFailureOverridesMap(gasErrorFailureOverrides, additionalNetworks = []) {
    return exports.NETWORKS_WITH_SAME_GAS_ERROR_FAILURE_OVERRIDES.concat(additionalNetworks).reduce((memo, chainId) => {
        memo[chainId] = gasErrorFailureOverrides;
        return memo;
    }, {});
}
exports.constructSameGasErrorFailureOverridesMap = constructSameGasErrorFailureOverridesMap;
exports.DEFAULT_GAS_ERROR_FAILURE_OVERRIDES = {
    gasLimitOverride: 2000000,
    multicallChunk: 70,
};
exports.GAS_ERROR_FAILURE_OVERRIDES = Object.assign({}, constructSameGasErrorFailureOverridesMap(exports.DEFAULT_GAS_ERROR_FAILURE_OVERRIDES));
exports.NETWORKS_WITH_SAME_SUCCESS_RATE_FAILURE_OVERRIDES = Object.values(sdk_core_1.ChainId);
function constructSameSuccessRateFailureOverridesMap(successRateFailureOverrides, additionalNetworks = []) {
    return exports.NETWORKS_WITH_SAME_SUCCESS_RATE_FAILURE_OVERRIDES.concat(additionalNetworks).reduce((memo, chainId) => {
        memo[chainId] = successRateFailureOverrides;
        return memo;
    }, {});
}
exports.constructSameSuccessRateFailureOverridesMap = constructSameSuccessRateFailureOverridesMap;
exports.DEFAULT_SUCCESS_RATE_FAILURE_OVERRIDES = {
    gasLimitOverride: 1300000,
    multicallChunk: 110,
};
exports.SUCCESS_RATE_FAILURE_OVERRIDES = Object.assign({}, constructSameSuccessRateFailureOverridesMap(exports.DEFAULT_SUCCESS_RATE_FAILURE_OVERRIDES));
exports.NETWORKS_WITH_SAME_BLOCK_NUMBER_CONFIGS = Object.values(sdk_core_1.ChainId);
function constructSameBlockNumberConfigsMap(blockNumberConfigs, additionalNetworks = []) {
    return exports.NETWORKS_WITH_SAME_BLOCK_NUMBER_CONFIGS.concat(additionalNetworks).reduce((memo, chainId) => {
        memo[chainId] = blockNumberConfigs;
        return memo;
    }, {});
}
exports.constructSameBlockNumberConfigsMap = constructSameBlockNumberConfigsMap;
exports.DEFAULT_BLOCK_NUMBER_CONFIGS = {
    baseBlockOffset: 0,
    rollback: { enabled: false },
};
exports.BLOCK_NUMBER_CONFIGS = Object.assign({}, constructSameBlockNumberConfigsMap(exports.DEFAULT_BLOCK_NUMBER_CONFIGS));
//# sourceMappingURL=data:application/json;base64,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